package controleur;

import architecture.Controleur;
import architecture.Navigateur;
import donnee.ExoplaneteDAO;
import modele.Exoplanete;
import vue.VueAjouter;
import vue.VueEditer;
import vue.VueEffacer;
import vue.VueExoplanetes;

public class ControleurExoplanetes extends Controleur{

	protected ExoplaneteDAO dao;
	public ControleurExoplanetes()
	{
		Journal.ecrire(Journal.NIVEAU.DETAIL, "new ControleurExoplanetes()");
		this.dao = new ExoplaneteDAO();
	}
	
	public void initialiser()
	{
		Journal.ecrire(Journal.NIVEAU.DETAIL, "ControleurExoplanetes.initialiser()");
		VueExoplanetes.getInstance().activerControles();
		VueAjouter.getInstance().activerControles();
		VueEditer.getInstance().activerControles();
		VueEffacer.getInstance().activerControles();
		
		VueExoplanetes.getInstance().afficherExoplanetes(dao.listerExoplanetes());
	}		
	public void notifierEnregistrerAjout()
	{
		Journal.ecrire(Journal.NIVEAU.DETAIL, "ControleurExoplanetes.notifierEnregistrerAjout()");
		Exoplanete exoplanete = VueAjouter.getInstance().lireExoplaneteEntree();
		dao.ajouterExoplanete(exoplanete);
		Navigateur.getInstance().afficherVue(VueExoplanetes.getInstance());
		VueExoplanetes.getInstance().afficherExoplanetes(dao.listerExoplanetes());
	}
	public void notifierEnregistrerEdition()
	{
		Journal.ecrire(Journal.NIVEAU.DETAIL, "ControleurExoplanetes.notifierEnregistrerEdition()");
		Exoplanete exoplanete = VueEditer.getInstance().lireExoplaneteEntree();
		dao.editerExoplanete(exoplanete);
		Navigateur.getInstance().afficherVue(VueExoplanetes.getInstance());
		VueExoplanetes.getInstance().afficherExoplanetes(dao.listerExoplanetes());
	}
	public void notifierActionAjouter() {
		Journal.ecrire(Journal.NIVEAU.DETAIL, "ControleurExoplanetes.notifierActionAjouter()");
		Navigateur.getInstance().afficherVue(VueAjouter.getInstance());		
	}
	public void notifierActionEditerPourExoplanete(Exoplanete exoplanete)
	{
		Journal.ecrire(Journal.NIVEAU.DETAIL, "ControleurExoplanetes.notifierActionEditerPourExoplanete()");
		VueEditer.getInstance().afficherExoplanete(exoplanete);
		Navigateur.getInstance().afficherVue(VueEditer.getInstance());
	}
	public void notifierActionEffacerPourExoplanete(Exoplanete exoplanete)
	{
		Journal.ecrire(Journal.NIVEAU.DETAIL, "ControleurExoplanetes.notifierActionEffacerPourExoplanete()");
		VueEffacer.getInstance().afficherExoplanete(exoplanete);
		Navigateur.getInstance().afficherVue(VueEffacer.getInstance());
	}
	public void notifierActionEffacerPourExoplanete(Exoplanete exoplanete, boolean reponse)
	{
		Journal.ecrire(Journal.NIVEAU.DETAIL, "ControleurExoplanetes.notifierActionEffacerPourExoplanete()");
		if(reponse == true)
		{
			dao.effacerExoplanete(exoplanete);
			VueExoplanetes.getInstance().afficherExoplanetes(dao.listerExoplanetes());
		}
		Navigateur.getInstance().afficherVue(VueExoplanetes.getInstance());
	}
}
